/*
 * Copyright (c) 2016 Bilibili
 * copyright (c) 2016 Zhang Rui <bbcallen@gmail.com>
 *
 * This file is part of ijkPlayer.
 *
 * ijkPlayer is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * ijkPlayer is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with ijkPlayer; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef ijkvodsdl_egl_h
#define ijkvodsdl_egl_h

#ifdef __APPLE__
#include "ijkvodsdl/ios/EGL/egl.h"
#include "ijkvodsdl/ios/EGL/eglplatform.h"
#else
#include <EGL/egl.h>
#include <EGL/eglext.h>
#include <EGL/eglplatform.h>
#endif
#include "ijkvodsdl_class.h"

typedef struct SDL_VoutOverlay SDL_VoutOverlay;
typedef struct IJK_EGL_Opaque  IJK_EGL_Opaque;

#if 0
enum {
    IJK_GLES2__GL_EXT_texture_rg,
    IJK_GLES2__MAX_EXT,
};
#endif

typedef struct IJK_EGL
{
    SDL_Class      *opaque_class;
    IJK_EGL_Opaque *opaque;

    EGLNativeWindowType window;

    EGLDisplay display;
    EGLSurface surface;
    EGLContext context;

    EGLint width;
    EGLint height;
    int    needRelease;

#if 0
    uint8_t gles2_extensions[IJK_GLES2__MAX_EXT];
#endif
} IJK_EGL;

IJK_EGL    *VODIJK_EGL_create();
void        VODIJK_EGL_free(IJK_EGL *egl);
void        VODIJK_EGL_freep(IJK_EGL **egl);

EGLBoolean  VODIJK_EGL_display(IJK_EGL* egl, EGLNativeWindowType window, SDL_VoutOverlay *overlay);
void        VODIJK_EGL_terminate(IJK_EGL* egl);

#endif
