/******************************************************************************

 @File         XFI.h

 @Version       1.0

 @Created      2017, 3, 6

 @Description  װļصһϵв

 @HISTORY:

******************************************************************************/

#ifndef _XFILEHELPER_H_
#define _XFILEHELPER_H_

#include "XTypes.h"
#include "XString.h"

class XFileHelper
{
public:
	/*
	* ʹļع֮ǰȵñ
	* 
	* @notice	ʹXFramework򲻱ص
	*
	* @param	szBaseDir Ŀ¼
	* @param	szLibraryDir Ŀ¼
	* @returns  xtrue
	*/
	static xbool		Init(const xchar* szBaseDir, const xchar* szDocuemnt, const xchar* szLibraryDir);
	
	/*
	* ʹļع֮ͨǳرʱ
	*
	* @notice	ʹXFramework򲻱ص
	*
	* @returns  xtrue
	*/
	static xbool		Close();
	
	/*
	* ֱĿ¼
	*
	* @param	szBaseDir Ŀ¼
	*/
	static void			SetBaseDir(const xchar* szBaseDir);

	/*
	* ȡĿ¼
	*/
	static const xchar*	GetBaseDir();
	static const xchar*	GetLibraryDir();
    static const xchar* GetDocument();
	/*
	* һ·ȡļ
	*
	* @notice չ
	*
	* @param	szFile ·
	* @param	szTitle ļ
	*
	* @returns  쳣szFile·ָΪβ򷵻xfalsextrue
	*/
	static xbool 		GetFileTitle(const xchar* szFile, xchar* szTitle);
	static xbool 		GetFileTitle(const xchar* szFile, XString& strTitle);

	/*
	* һ·ȡļĿ¼
	*
	* @notice β·ָ
	*
	* @param	szFile ·
	* @param	szPath ļĿ¼
	*
	* @returns  쳣szFile·ָΪβ򷵻xfalsextrue
	*/
	static xbool 		GetFilePath(const xchar* szFile, xchar* szPath);
	static xbool 		GetFilePath(const xchar* szFile, XString& strPath);

	/*
	* жļչǷƥ
	*
	* @param	szFileName ļ
	* @param	szExtension չ
	*
	* @returns  ƥ䷵trueƥ䷵xfalse
	*/
	static xbool 		FileExtensionMatched(const xchar* szFileName, const xchar* szExtension);

	/*
	* ļĺ׺
	*
	* @param	szFileName ļ
	* @param	szNewExtension µչ
	*
	* @returns  xtrue
	*/
	static xbool 		ChangeExtension(xchar* szFileName, const xchar* szNewExtension);
	static xbool 		ChangeExtension(XString& strFileName, const xchar* szNewExtension);

	/*
	* ļǷ
	*
	* @param	szFileName ļ
	*
	* @returns  ڷxtrueڷxfalse
	*/
	static xbool 		FileExisted(const xchar * szFileName);
	
	/*
	* Ƴļչ
	*
	* @param	strFileName ļ
	*
	*/
	static void 		RemoveExtension(XString& strFileName);

	/*
	* ļ׼·ָΪ/
	*
	* @notice	IOSƽ̨Ҫдĸ·˲ĸĳСд
	*
	* @param	szFileName ļ
	*
	*/
	static void 		Normalize(xchar* szFileName);
	static void 		Normalize(const xchar* szSrcFileName, xchar* szDstFileName);

	static void			GetRelativePathNoBase(const xchar* szFullpath, const xchar* szParentPath, xchar* szRelativepath);
	static void			GetRelativePathNoBase(const xchar* szFullpath, const xchar* szParentPath, XString& strRelativePath);
	static void			GetFullPathNoBase(xchar* szFullpath, const xchar* szBaseDir, const xchar* szFilename);
	static void			GetFullPathNoBase(XString& strFullpath, const xchar* szBaseDir, const xchar* szFilename);
	static void			GetFullPath(xchar* szFullPath, const xchar* szFolderName, const xchar* szFileName);
	static void			GetFullPath(xchar* szFullPath, const xchar* szFileName);
	static void			GetFullPath(XString& strFullPath, const xchar* szFolderName, const xchar* szFileName);
	static void			GetFullPath(XString& strFullPath, const xchar* szFileName);
	static void			GetFullPathWithUpdate(XString& strFullPath, const xchar* szFileName, bool bNoCheckFileExist = false);
	static void			GetFullPathWithDocument(XString& strFullPath, const xchar* szFileName, bool bNoCheckFileExist = false);
	static void			GetRelativePath(const xchar* szFullPath, const xchar* szFolderName, xchar* szRelativePath);
	static void			GetRelativePath(const xchar* szFullPath, xchar* szRelativePath);
	static void			GetRelativePath(const xchar* szFullPath, const xchar* szFolderName, XString& strRelativePath);
	static void			GetRelativePath(const xchar* szFullPath, XString& strRelativePath);
};

#endif

