/******************************************************************************

@File         XBlendShapeTarget.h

@Version       1.0

@Created      2017, 4, 16

@Description

@HISTORY:

******************************************************************************/

#ifndef _X_BLENDSHAPE_TARGET_H_
#define _X_BLENDSHAPE_TARGET_H_

#include "XMemBase.h"
#include "XArray.h"
#include "XString.h"
#include "XSkinData.h"
#include "XBlendShapeManager.h"
#include <utility>

#define UPDATEBLENDSHAPE_ASYNC 0

#if UPDATEBLENDSHAPE_ASYNC
#include <future>
#endif

struct XBlendShapeTarget : public XMemBase
{
							XBlendShapeTarget() = default;
	xbool					DoSave(XFileBase* pFile) const;
	xbool					DoLoad(XFileBase* pFile);

	/*
	* BlendShapeϢ
	*
	* @param	vPositionDelta   ԴλƵƫ
	* @param	vTangentZDelta   Դߵƫ
	* @param	nMeshVertexIndex meshеĶ
	*/
	struct BlendShapeVertex
	{
		XVECTOR3			  vPositionDelta;
		XVECTOR3			  vTangentZDelta;
		xint32				  nMeshVertexIndex;
	};

	XString                   strBShpTargetName;
	XArray<BlendShapeVertex>  aBShpVertices;
	xint32                    nTargetMeshVertexNum;			// ǰδʹ
	xint32                    nTargetMeshVertexStartIndex;		// ǰδʹ
};

struct XBlendShapeChannel : public XMemBase
{
								XBlendShapeChannel() = default;
	xbool						DoSave(XFileBase* pFile) const;
	xbool						DoLoad(XFileBase* pFile, xuint32 loadVersion);

	struct TargetPair
	{
		xint32 index;
		xfloat32 value;
	};
	XString						strChannelName;
	xfloat32					defaultValue = 0.0f;
	XArray<TargetPair>			aTargets;	
};

struct XMeshBlendShapeTarget : public XMemBase
{	
										XMeshBlendShapeTarget() = default;
	xbool								DoSave(XFileBase* pFile) const;
	xbool								DoLoad(XFileBase* pFile, xuint32 loadVersion);

	XString								strTargetMeshName;

	/*
	* Ӧԭʼ	
	* @notice ԭʼfbxתʱֳܻɶ񡣴¼ŴӦԭʼǸ
	*/
	xint32								nOriginalMeshIndex = -1;		
	XArray<XBlendShapeTarget>			aTargets;
	XArray<XBlendShapeChannel>			aChannels;	
};


class XSkinBlendShapeWeight
{
	friend class XSkinBlendShapeTarget;
public:
	/*
	* ȨضӦ
	*
	* @notice һȨصڶǻfbxеԷOriginalMesh
	*
	* @param	RawMesh		Ӧתģʱ
	* @param	OriginalMesh   Ӧfbxеԭʼ  
	*/
	enum MeshWeightType
	{
		RawMesh,
		OriginalMesh,
	};
public:
                                        XSkinBlendShapeWeight() : m_pTargetBlendShapeTarget(NULL), m_eMeshWeightType(MeshWeightType::OriginalMesh) {}
                                        XSkinBlendShapeWeight(XSkinBlendShapeWeight&& other);
	XSkinBlendShapeWeight&				operator=(const XSkinBlendShapeWeight& other);
	XSkinBlendShapeWeight&				operator=(XSkinBlendShapeWeight&& other);

	MeshWeightType						GetMeshWeightType() const { return m_eMeshWeightType; }

	const XSkinBlendShapeTarget*		m_pTargetBlendShapeTarget;
	MeshWeightType						m_eMeshWeightType;
	/*
	* @notice  [mesh index][morph channel index]
	*/
	XArray<XArray<xfloat32>>				m_afWeights;
	
};

class XModel;
struct XSkinModelBlendShapeWeight
{
public:
                                        XSkinModelBlendShapeWeight();
                                        XSkinModelBlendShapeWeight(const XModel* pTargetSkinModel, XSkinBlendShapeWeight::MeshWeightType meshType = XSkinBlendShapeWeight::MeshWeightType::OriginalMesh);
                                        
                                        XSkinModelBlendShapeWeight(const XSkinModelBlendShapeWeight& other);
                                        XSkinModelBlendShapeWeight(XSkinModelBlendShapeWeight&& other);
	XSkinModelBlendShapeWeight&			operator=(const XSkinModelBlendShapeWeight& other);
	XSkinModelBlendShapeWeight&			operator=(XSkinModelBlendShapeWeight&& other);

	xbool                               IsEmpty() const { return m_aWeights.Num() == 0; }

	void                                AdditiveBlendFrom(const XSkinModelBlendShapeWeight& morphWeights, xfloat32 fBlendWeight);
	void                                LerpBlendFrom(const XSkinModelBlendShapeWeight& morphWeights, xfloat32 fBlendWeight);
	void                                OverrideFrom(const XSkinModelBlendShapeWeight& morphWeights);
	void                                ClearValueToZero();

	friend xbool                        operator==(const XSkinModelBlendShapeWeight& left, const XSkinModelBlendShapeWeight& right);
	friend xbool                        operator!=(const XSkinModelBlendShapeWeight& left, const XSkinModelBlendShapeWeight& right) { return !(left == right); }	

#if UPDATEBLENDSHAPE_ASYNC
	void								SetInUseByBlendShapeInstance(xbool inUse) const;

	mutable std::atomic<xbool>			m_bInUseByBShpInstance;	
#endif	
	const XModel*						m_pTargetSkinModel = NULL;
	/*
	* @notice  [skin index][morph target index]
	*/
	XArray<XArray<XSkinBlendShapeWeight>>	m_aWeights;

private:
	void								MultiplyWeight(xfloat32 fBlendWeight);    
};

class XThreadMutex;

struct BlendShapeWeightBufferWithMutex
{
     BlendShapeWeightBufferWithMutex(const XSkinModelBlendShapeWeight& weights, XThreadMutex* pBShpWeightMutex)
          : weights(weights), pBShpWeightMutex(pBShpWeightMutex) {}

	const XSkinModelBlendShapeWeight&        weights;
	XThreadMutex*							 pBShpWeightMutex;
};

class XSkinBlendShapeTarget : public IBlendShapeAsset
{
public:
	struct RangePair
	{
		xint32 e1;
		xint32 e2;
	};
public:
                                             XSkinBlendShapeTarget() = default;
                                             ~XSkinBlendShapeTarget();
                                             XSkinBlendShapeTarget(XSkinBlendShapeTarget const& other) = delete;
                                             XSkinBlendShapeTarget(XSkinBlendShapeTarget&& other);
	XSkinBlendShapeTarget&                   operator =(XSkinBlendShapeTarget const& other) = delete;
	XSkinBlendShapeTarget&                   operator =(XSkinBlendShapeTarget&& other);

	void                                     Release();

	static const XString&                    FileExtension() { static XString strExtension = ".mph"; return strExtension; }

	xint32                                   GetMeshBShpTargetNum() const { return m_aMeshBShpTargets.Num(); }
	xint32	                                 GetOriginalMeshNum() const { return m_anOriginalMeshIndexToRawMeshStartIndex.Num() - 1; }
	
	/*
	* ȡBlendShapeTarget
	*
	* @param	nMeshIndex Ӧתģͺֵ
	*/
	const XMeshBlendShapeTarget*			GetMeshBShpTarget(xint32 nMeshIndex) const { return m_aMeshBShpTargets[nMeshIndex]; }

	const XString&							GetOriginalMeshName(xint32 nOriginalMeshIndex) const { return m_astrOriginalMeshNames[nOriginalMeshIndex]; }
	RangePair								GetOriginalMeshToRawMeshRange(xint32 nOriginalMeshIndex) const { return { m_anOriginalMeshIndexToRawMeshStartIndex[nOriginalMeshIndex], m_anOriginalMeshIndexToRawMeshStartIndex[nOriginalMeshIndex + 1] }; }
	
	XArray<XString>&						GetOriginalMeshNames() { return m_astrOriginalMeshNames; }
	const XArray<XString>&					GetOriginalMeshNames() const { return m_astrOriginalMeshNames; }

	/*
	* ȡԭʼ뵼ĶӦϵ
	*/
	const XArray<xint32>&                    GetOriginalMeshIndexToRawMeshStartIndexMapping() const { return m_anOriginalMeshIndexToRawMeshStartIndex; }

	/*
	* @notice ص޸m_anOriginalMeshIndexToRawMeshStartIndexֵ
	*/
	XArray<xint32>&                          GetOriginalMeshIndexToRawMeshStartIndexMapping() { return m_anOriginalMeshIndexToRawMeshStartIndex; }	

	/*
	* ȡԭʼȾ֮ĶӦϵ
	*
	* @notice ӦͷƣԻֳɸ(fix flkǰת˹ͷĹһ㲻Ϊͷٲ)
	*/
	const XArray<xint32>&                    GetOriginalMeshIndexToRenderMeshStartIndexMapping() const { return m_anOriginalMeshIndexToRenderMeshStartIndex; }

	/*
	* @notice ص޸m_anOriginalMeshIndexToRenderMeshStartIndexֵ
	*/
	XArray<xint32>&                          GetOriginalMeshIndexToRenderMeshStartIndexMapping() { return m_anOriginalMeshIndexToRenderMeshStartIndex; }

	/*
	* SkinDataBlendshapeǷƥ
	*
	* @notice SkinDataһһͬɵBlendshapeƥ䣬ֻҪ˺Ϊtrue˵С
	*/
	xbool                                    IsTargetMatch(XSkinData& targetSkinData) const;

	virtual xbool                            DoSave(XFileBase* pFile) const override;
	virtual xbool                            DoLoad(XFileBase* pFile) override;

	XSkinBlendShapeWeight                    CreateBlendShapeWeightBuffer(XSkinBlendShapeWeight::MeshWeightType eMeshType) const;

	/*
	*  m_anOriginalMeshIndexToRenderMeshStartIndex Ӧϵ
	*
	* @notice صʱᱻ
	*/
	xbool								     BuildRuntimeMeshMapping(const XSkinData& buildTo);

	
	const XArray<XMeshBlendShapeTarget*>&    GetData() const { return m_aMeshBShpTargets; }
	XArray<XMeshBlendShapeTarget*>&		     GetData() { return m_aMeshBShpTargets; }

protected:
	virtual void						     OnReload() override;


	/*
	* BlendShapeTarget
	*
	* @notice	 е˳򣬶Ӧתģʱ
	*/
	XArray<XMeshBlendShapeTarget*>           m_aMeshBShpTargets;

	XArray<XString>                          m_astrOriginalMeshNames;

	/*
	* ԭʼ뵼ĿʼӦϵ
	*
	* @notice	Ӧϵ . ԭʼ3 ԭʼ13ӦϵΪ[0,1,4,5]
	*		ԭʼ1ӦrawʼΪ1, ԭʼ2ӦrawʼΪ4,14֮[1,2,3]ǶӦԭʼ1ġ
	*/
	XArray<xint32>                           m_anOriginalMeshIndexToRawMeshStartIndex;

	/*
	* ԭʼȾӦϵ
	*
	* @notice Ӧƣ ˴ΪӦͷƣ
	*		ԻֳɸȾ	(fix flkǰת˹ͷĹһ㲻Ϊͷٲ֣ ȾҲskinеȾͬ)
	*/
	XArray<xint32>                           m_anOriginalMeshIndexToRenderMeshStartIndex;

	XString                                  m_strTargetSkinDatXFile;
};


class XBlendShapeInstance
{
public:
	enum VertexType { Local,	Skin, Count };
	struct SkinBlendShapePack
	{
		struct BlendShapeVertexDefinePack
		{
            BlendShapeVertexDefinePack() : m_pVertexDefBShp(NULL) {}
            ~BlendShapeVertexDefinePack()	{ X_SAFEDELETE(m_pVertexDefBShp); }
			XVertexDesc*      m_pVertexDefBShp;
			VertexType        m_eVertexType = VertexType::Count;
		};

        SkinBlendShapePack() : m_pBShpLocalDynamicVB(NULL), m_pBShpSkinDynamicVB(NULL) {}
        ~SkinBlendShapePack() { Clear(); }
        SkinBlendShapePack(SkinBlendShapePack const& other) = delete;
        SkinBlendShapePack& operator=(SkinBlendShapePack const& other) = delete;
		void             Clear();

		XBlendShapeVertexVB* m_pBShpLocalDynamicVB;
		XBlendShapeVertexVB* m_pBShpSkinDynamicVB;
		XArray<BlendShapeVertexDefinePack> m_XBShpMeshVertexDefinePack; // [render mesh index]
	};

#if UPDATEBLENDSHAPE_ASYNC
	struct ResultGetter
	{
		ResultGetter() = default;
		ResultGetter(std::future<void> result);
		ResultGetter(ResultGetter&& other);
		ResultGetter& operator=(ResultGetter&& other);
		void Wait() const { if (result.valid()) result.wait(); }

		std::future<void> result;
	};
#endif

public:

                                   XBlendShapeInstance();
                                   ~XBlendShapeInstance();
                                   XBlendShapeInstance(const XModel* pSkinModel);
                                   XBlendShapeInstance(XBlendShapeInstance const& other) = delete;
                                   XBlendShapeInstance operator=(XBlendShapeInstance const& other) = delete;
                                   XBlendShapeInstance(XBlendShapeInstance&& other);
	XBlendShapeInstance&           operator=(XBlendShapeInstance&& other);

	void                           UpdateBlendShapeVertexBuffer(BlendShapeWeightBufferWithMutex BShpWeightBuffer, xbool& dirtyFlag);
#if UPDATEBLENDSHAPE_ASYNC
    void                           UpdateBlendShapeVertexBufferAsync(BlendShapeWeightBufferWithMutex BShpWeightBuffer, XBlendShapeInstance::ResultGetter& result, xbool& dirtyFlag);
#endif

	/*
	* ύGPU
	*
	* @notice Renderᱻ
	*/
	void                           CommitGPUBuffers();
	const XBlendShapeInstance::SkinBlendShapePack::BlendShapeVertexDefinePack* GetBlendShapeVertexDefinePack(xint32 nSkinIndex, xint32 nMeshIndex) const { return &m_apSkinBShpPacks[nSkinIndex]->m_XBShpMeshVertexDefinePack[nMeshIndex]; }

	void                           Clear() { m_apSkinBShpPacks.Clear(false); }

	XBlendShapeVertexVB*           GetBlendShapeVB(xint32 nSkinIndex, xint32 nMeshIndex);

private:

	void                           DoUpdateBlendShapeVertexBuffer(BlendShapeWeightBufferWithMutex BlendShapeWeightBuffer);
	void                           CreateVertexDefine(const XSkinData* pSkinData, xint32 nSkinIndex, xint32 nMeshIndex);

	XArray<SkinBlendShapePack*>    m_apSkinBShpPacks; // [skin index]
	const XModel*                  m_pTargetSkinModel = nullptr;

#if UPDATEBLENDSHAPE_ASYNC
	std::atomic<bool>              m_bUpdating;
#endif
};

#endif

