#ifndef _PHYSICAL_MANAGER_H_
#define _PHYSICAL_MANAGER_H_

#include "XMath3D.h"
#include "XArray.h"
#include "XPhysicalInterface.h"
#include "IXRigidBody.h"
#include "IXPhysicsRes.h"
#include "IXSkeletalPhysicsInstance.h"

class IXCloth;
class XBaseCoordSpace;
class IXPhysicsScene;

class IXPhysicalManager : public IXPhysicalManagerBase
{
public:
	virtual					~IXPhysicalManager() {};

	/**
	* ʼͷ
	*/
	virtual xbool			Init() = 0;
	virtual void			Release() = 0;
	
	/**
	* һ
	* @note 󳡾
	*		delete
	*
	* @param szSceneName 
	* @return ָ룬ʧܷNULL
	*/
	virtual IXPhysicsScene*	CreateScene(const xchar* szSceneName) = 0;

	/*---------------------------*/
	/*------Cloth Interface------*/
	/*---------------------------*/

	/**
	* һģʵĳMeshϻȡʵ
	*
	* @param pInstance ģʵָ
	* @param szMeshName mesh
	* @return ʵָ, ûа󶨲Ϸؿָ
	*/
	virtual IXCloth*		GetCloth(IXModelInstance* pInstance, const xchar* szMeshName) = 0;
	
	/**
	* һģʵȡеĲʵ
	*
	* @param pInstance ģʵָ
	* @param aCloth Cloth
	* @return 
	*/
	virtual void			GetCloth(IXModelInstance* pInstance, XArray<IXCloth*>& aCloth) = 0;

	/**
	* ȡдϵmesh
	*
	* @param pInstance ģʵָ
	* @param out aMeshName 󶨲ϵmesh
	* @return 
	*/
	virtual void			GetMeshNameWithCloth(IXModelInstance* pInstance, XArray<XString>& aMeshName) const = 0;

	/**
	* Ӳϼһʵ
	* @note ԴAddClothӵģͳɹֶͷţҪRelease
	* 
	* @param szPath ϵ·
	* @return ʵָ, ʧܷؿָ
	*/
	virtual IXCloth*		CreateCloth(const xchar* szPath) = 0;

	/**
	* ԶʵģͰ󶨣ݲƥ
	*
	* @param pInstance ģʵָ
	* @param pCloth ʵָ
	*/
	virtual xbool			AddCloth(IXModelInstance* pInstance, xint32 nSkinIndex, IXCloth* pCloth) = 0;
	
	/**
	* Ƴģʵĳmeshв
	* @note ƳֱReleaseԴ,Ժܻ޸
	*
	* @param pInstance ģʵָ
	*/
	virtual void			RemoveCloth(IXModelInstance* pInstance) = 0;


	// ͣ
	/**
	* ʵģ͵ĳmesh
	*
	* @param pInstance ģʵָ
	* @param szMeshName ģmesh
	* @param pCloth ʵָ
	* @return ʧmeshѰ/clothѰ/meshNameδҵ/Ʋƥ.
	*/
	virtual xbool			AddCloth(IXModelInstance* pInstance, xint32 nSkinIndex, const xchar* szMeshName, IXCloth* pCloth) = 0;

	/**
	* ƳģʵĳmeshĲ
	* @note ƳֱReleaseԴ,Ժܻ޸
	*
	* @param pInstance ģʵָ
	* @param szMeshName ģmesh
	*/
	virtual void			RemoveCloth(IXModelInstance* pInstance, const xchar* szMeshName) = 0;
	// ͣ


	/**
	* ģʵǰĲϢõSkin
	* @note ʹ,SkinSaveǰ,򽫲ģ͵ĲϢ
	* 
	* @param pInstance ģʵָ
	*/
	virtual void			SetClothInfoToSkin(IXModelInstance* pInstance) = 0;
	
	/**
	* 沼ļ
	* @note ǰԱֻвϢ
	*
	* @param pInstance ģʵָ
	*/
	virtual xbool			SaveCloth(const xchar* szFile, IXCloth* pCloth) = 0;

	/*-------------------------------*/
	/*------RigidBody Interface------*/
	/*-------------------------------*/

	/**
	* һ
	* @note delete
	*
	* @param eType 
	* @param pBindObject һBaseCoordSpace,ǰģͺЧ
	*/
	virtual IXRigidBody*	CreateRigidBody(RigidActorType eType, XBaseCoordSpace* pBindObject) = 0;
	
	/**
	* ӲϼһԴ(ײ)
	* @note Release
	*
	* @param szPath phy·
	* @param bReload Ƿؼ
	* @return Դָ, ʧܷؿָ
	*/
	virtual IXPhysicsRes*	LoadPhysicsRes(const xchar* sz, xbool bReload = xfalse) = 0;	

	/**
	* ӹԴʵ
	*
	* @param szSkeletalPhysicsRes Դ·
	* @return ʵָ, ʧܷؿָ
	*/
	virtual IXSkeletalPhysicsInstance* CreateSkeletalPhysicsInstance(const xchar* szSkeletalPhysicsRes, IXModelInstance* pModelInstance, IXPhysicsScene* pOwningScene) = 0;

	/**
	* ȫַЧ
	*/
	virtual void			SetWindSpeed(xfloat32 fWindSpeed) = 0;
	virtual xfloat32		GetWindSpeed() const = 0;
	virtual void			SetWindDir(const XVECTOR3& vDir) = 0;
	virtual const XVECTOR3&	GetWindDir() const = 0;

	/**
	* ºڲ
	*/
	virtual IXCloth*		LoadClothText(const xchar* szPath) = 0;
	virtual IXPhysicsRes*	CreatePhysicsRes(PhysicsResourceType eType, const xchar* szName = NULL) = 0;
	virtual xbool			SavePhysicsRes(const xchar* szFile, IXPhysicsRes* pRes) = 0;
};

extern IXPhysicalManager* g_pIXPhysicalManager;

#endif