#ifndef _IXRIGIDACTOR_H_
#define _IXRIGIDACTOR_H_

#include "XMath3D.h"

class IXPhysicsRes;
class XBaseCoordSpace;
enum RigidActorType
{
	// ֻ̬Ӱ壬ᱻӰ
	RAT_STATIC,
	// ̬Ӱ壬ҲᱻӰ
	RAT_DYNAMIC,
	// future, ѧ̬һͣӰ죬̬ActorKINEMATIC Actorײ
	// RAT_KINEMATIC,
};

/****************************************/
/* ״						*/
/********************** *****************/
struct XShapeMaterial
{
	XShapeMaterial(xfloat32 sf, xfloat32 df, xfloat32 r)
		: fStaticFriction(sf)
		, fDynamicFriction(df)
		, fRestitution(r){}
	/**
	* Ħϵ
	*
	* @range [0, X_MAX_FLT32]
	*/
	xfloat32	fStaticFriction;

	/**
	* Ħϵ
	*
	* @range [0, X_MAX_FLT32]
	*/
	xfloat32	fDynamicFriction;

	/**
	* ϵ
	* ԽԽ
	* @range [0, 1]
	*/
	xfloat32	fRestitution;
};

/****************************************/
/* 								*/
/********************** *****************/
class IXRigidBody : public XMemBase
{
public:
	virtual						~IXRigidBody(){}
	
	/**
	* ΪһԴ
	* @note ɹԴü1
	*
	* @param pRes Դ
	* @param bReplace Ƿ滻,Ϊxtrue,滻ԭԴ,Ϊxfalse,δ,Ѱ򲻰
	* @return ɹxtrue,ʧܷxfalse
	*/
	virtual xbool				BindPhysicsRes(IXPhysicsRes* pRes, xbool bReplace = xfalse) = 0;

	/*
	* Get
	*/
	virtual XBaseCoordSpace*	GetBaseCoordSpace() = 0;

	/*
	* ģ
	*/
	virtual xbool				IsSimulate() const = 0;
	virtual void				SetSimulate(xbool bSet) = 0;

	/*
	* 
	*/
	virtual RigidActorType 		GetType() const = 0;
	virtual void				SetType(RigidActorType eType) = 0;
	
	/*
	* ״
	*/
	virtual XShapeMaterial		GetMaterial() const = 0;
	virtual void				SetMaterial(const XShapeMaterial& mat) = 0;

	/*
	* ײ¼
	* @note ڸײʱIXPhysicalSceneEventListener::OnContact
	*/
	virtual xbool				IsNotifyContact() const = 0;
	virtual void				SetNotifyContact(xbool bSet) = 0;

	/*
	* ǷӰ
	*/
	virtual xbool				IsGravityEnabled() const = 0;
	virtual void				SetGravityEnabled(xbool bSet) = 0;


	// ºTypeΪDynamicʱЧ
	
	/*
	* CCD
	* @note ӦCCDЧӦ
	*/
	virtual xbool				IsCCDEnabled() const = 0;
	virtual void				SetCCDEnabled(xbool bSet) = 0;
	
	/*
	* λkg
	* @note 0
	* @range [0, X_MAX_FLT32]
	*/
	virtual xfloat32			GetMass() const = 0;
	virtual void				SetMass(xfloat32 f) = 0;

	/**
	* ٶȺͽٶ
	* @note δģ,Ч
	*/
	virtual XVECTOR3			GetLinearVelocity() const = 0;
	virtual void				SetLinearVelocity(const XVECTOR3& vVelocity) = 0;	
	virtual XVECTOR3			GetAngularVelocity() const = 0;
	virtual void				SetAngularVelocity(const XVECTOR3& vAngle) = 0;

	/*
	* ٶϵͽٶϵ
	*
	* @range [0, X_MAX_FLT32]
	*/
	virtual xfloat32			GetLinearDamping() const = 0;
	virtual void				SetLinearDamping(xfloat32 fLinearDamping) = 0;
	virtual xfloat32			GetAngularDamping() const = 0;
	virtual void				SetAngularDamping(xfloat32 fAngularDamping) = 0;

	/*
	* ײ
	* @default 0xFFFF
	*/
	virtual xuint32				GetFilterData() const = 0;
	virtual void				SetFilterData(xuint32 nFilter) = 0;
};

#endif
