#ifndef _IXPHYSICSSCENE_H_
#define _IXPHYSICSSCENE_H_

#include "XArray.h"
#include "XMath3D.h"

class IXCloth;
class IXRigidBody;
class IXWorld;
class IXSkeletalPhysicsInstance;

/****************************************/
/* ¼						*/
/********************** *****************/
class IXPhysicalSceneEventListener : public XMemBase
{
public:
	/**
	* ײʱص
	*
	* @param ײActor
	*/
	virtual void OnContact(IXRigidBody* pBody0, IXRigidBody* pBody1) = 0;
};

/********************************************************/
/* 											*/
/* ӵеԴ,ϡ塢	*/
/********************** *********************************/
class IXPhysicsScene : public XMemBase
{
public:
	virtual ~IXPhysicsScene(){}

	/**
	* ȡ
	*/
	virtual const xchar*		GetName() = 0;
	
	/**
	* ӵ
	*
	* @param  pCloth ָ
	* @return ʧӵ
	*/
	virtual xbool				AddCloth(IXCloth* pCloth) = 0;
	
	/**
	* һ鲼ӵ
	* @note	Ӹϣһʧܣִ֮Ĳ
	* @param  aCloth 
	* @return һʧܷxfalse
	*/
	virtual xbool				AddCloth(const XArray<IXCloth*>& aCloth) = 0;
	
	/**
	* ϴӳƳ
	*
	* @param  pCloth ָ
	*/
	virtual void				RemoveCloth(IXCloth* pCloth) = 0;

	/**
	* һӵ
	* 
	* @param  pRigidBody ָ
	* @return ʧӵ
	*/
	virtual xbool				AddRigidBody(IXRigidBody* pRigidBody) = 0;
	
	/**
	* ӳƳ
	*
	* @param  pRigidBody ָ
	*/
	virtual void				RemoveRigidBody(IXRigidBody* pRigidBody) = 0;

	/*
	* Tick
	*/
	virtual void				Tick(xfloat32 fTime) = 0;
	/*
	* RenderеĲ
	*/
	virtual void				Render(IXWorld* pScene) = 0;

	/*
	* ΪӼ
	*/
	virtual void				AddEventListener(IXPhysicalSceneEventListener* pListener) = 0;
	/*
	* Ƴ
	*/
	virtual void				RemoveEventListener(IXPhysicalSceneEventListener* pListener) = 0;

	/*
	* ó
	*/
	virtual XVECTOR3			GetGravity() = 0;
	virtual void				SetGravity(const XVECTOR3& vGravity) = 0;
};

#endif
