//
//  MMGestureDetector.h
//  Pods
//
//  Created by YuAo on 11/14/16.
//
//

#import <Foundation/Foundation.h>
#import <AVFoundation/AVFoundation.h>
#import "MMCVDetectionOptions.h"

@class MMObjectFeature;

NS_ASSUME_NONNULL_BEGIN

@interface MMObjectDetectOption :NSObject <NSCopying>
@property (nonatomic, assign) MMCVImageOrientation orientation;
@property (nonatomic, assign) float boundsScale;
@end

@interface MMObjectDetectionResult : NSObject <NSCopying>

@property (nonatomic,readonly) NSArray<MMObjectFeature *> *features;

@property (nonatomic,readonly) float scoreThreadhold;

@property (nonatomic,readonly) NSArray<MMObjectFeature *> *rawFeatures;

- (instancetype)initWithRawFeatures:(NSArray<MMObjectFeature *> *)rawFeatures scoreThreadhold:(float)scoreThreadhold;

@end

@interface MMObjectDetector : NSObject

@property (nonatomic,copy,readonly) NSURL *modelURL;

+ (BOOL)validateModelBundle:(NSBundle *)bundle;

- (instancetype)init NS_UNAVAILABLE;

- (nullable instancetype)initWithModelBundle:(nullable NSBundle *)bundle error:(NSError **)error NS_DESIGNATED_INITIALIZER;

- (NSArray<MMObjectFeature *> *)featuresInPixelBuffer:(CVPixelBufferRef)pixelBuffer;

- (MMObjectDetectionResult *)detectFeaturesInPixelBuffer:(CVPixelBufferRef)pixelBuffer;

- (MMObjectDetectionResult *)detectFeaturesInPixelBuffer:(CVPixelBufferRef)pixelBuffer orientation:(MMCVImageOrientation)orientation;

- (MMObjectDetectionResult *)detectFeaturesInPixelBuffer:(CVPixelBufferRef)pixelBuffer option:(MMObjectDetectOption *)option;

@end

NS_ASSUME_NONNULL_END
